/*************************************************************
*
*  Function for reading triangle data for the Natural Element
*  Method (NEM): triangle connectivities, no of quadrature
*  points, and neighbors [optional] for each triangle 
*
*************************************************************/

#include <stdio.h>

#include "defines.h"

int triangle_data(FILE *file_ptr,int tri_connect[][NODES_PER_TRIANGLE],int tri_quad[],int tri_boundary[])

{
   int i, j, ns, nd[NODES_PER_TRIANGLE], quadrature, t1, t2, t3;
   char line[200];

   i = 0;

   while (1) 
   {
     if (fgets(line,200,file_ptr) == NULL) {
	printf("Error in Triangle block data: EOF reached\n");
	exit(1); /* EOF reached within the block */
     }
     ns = sscanf(line,"%d %d %d %d %d %d %d",nd,nd+1,nd+2,&quadrature,&t1,&t2,&t3);
     if (ns == 7) {
         for (j = 0; j < NODES_PER_TRIANGLE; j++) {
            tri_connect[i][j] = nd[j];
         }
         tri_quad[i] = quadrature;
	 if (t1 == -1 || t2 == -1 || t3 == -1) {
	    tri_boundary[i] = 1;
	 }
	 else {
	    tri_boundary[i] = 0;
	 }
     } 
     else if (ns == 4) {
	 for (j = 0; j < NODES_PER_TRIANGLE; j++) {
            tri_connect[i][j] = nd[j];
         }
         tri_quad[i] = quadrature;
         tri_boundary[i] = 0;
     }
     else if (ns == 0) {
	 if (line[0] == '!')
	    continue; /* comment line, so skip to the next line */
         else
	    break; /* end of triangle connectivity data */
     }
     else {
	 printf("Error in Triangle block data\n");
	 exit(1);
     }
     i++;
   }

   return i; /* return total number of triangles */

} /* end of tri_data function */
