/**************************************************
*
*  Function to read traction BCs on nodes for the
*  Natural Element Method (NEM)
*
**************************************************/

#include <stdio.h>
#include <string.h>

#include "defines.h"

int traction_data(FILE *file_ptr,int node_nbc[],double tx[], double ty[])
{
   int i, nbc_cells, ns;
   int nd0, nd1;
   double tx0, ty0, tx1, ty1;

   char line[200];

   i = nbc_cells = 0;

   while (1)
   {
     if (fgets(line,200,file_ptr) == NULL) {
	printf("Error in Traction block data: EOF reached\n");
	exit(1); /* EOF reached within the block */
     }
     ns = sscanf(line,"%d %lf %lf %d %lf %lf",
 	         &nd0,&tx0,&ty0,&nd1,&tx1,&ty1);
     if (ns == 6) {
        node_nbc[i] = nd0;
        node_nbc[i+1] = nd1;
        tx[i] = tx0; ty[i] = ty0;
        tx[i+1] = tx1; ty[i+1] = ty1;
     }
     else if (ns == 0) {
        if (line[0] == '!')
	   continue; /* comment line, so skip to next line */
	else
           break; /* end of traction BC data */
     }
     else {
        printf("Error in Traction block data\n");
        exit(1);
     }
     i += NODES_PER_NBCCELL; ++nbc_cells;
   }

   return nbc_cells; /* return number of cells for natural BCs */

} /* end of traction_data function */
