/******************************************************
*
*  Function for reading nodal grid data, essential BCs,
*  and nodal boundary marker for the Natural Element
*  Method (NEM)
*
******************************************************/

#include <stdio.h>

#include "defines.h"

int nodal_data(FILE *file_ptr,double coord[][NSD],int fixity[][NSD],double uebc[][NSD],int node_boundary[])

{
   int i, ns;
   int fix_x, fix_y, node_marker;
   double x, y, ux, uy;
   char line[200];

   i = 0;

   while (1) 
   {
     if (fgets(line,200,file_ptr) == NULL)  {
	printf("Error in Nodal block data: EOF reached\n");
	exit(1); /* EOF reached within the block */
     }
     ns = sscanf(line,"%lf %lf %d %d %lf %lf %d",&x,&y,&fix_x,&fix_y,&ux,&uy,&node_marker);
     if (ns == 6) {
        coord[i][0] = x; coord[i][1] = y;
        fixity[i][0] = fix_x;
        fixity[i][1] = fix_y;
        uebc[i][0] = ux;
        uebc[i][1] = uy;
	node_boundary[i] = 0;
     }
     else if (ns == 7) {
        coord[i][0] = x; coord[i][1] = y;
        fixity[i][0] = fix_x;
        fixity[i][1] = fix_y;
        uebc[i][0] = ux;
        uebc[i][1] = uy;
	node_boundary[i] = node_marker;
     }
     else if (ns == 0) {
	if (line[0] == '!') 
	   continue; /* comment line, so skip to next line */
        else
           break; /* end of nodal data */
     }
     else {
        printf("Error in Nodal block data\n");
        exit(1);
     }
     i++;
   }

   return i; /* return total number of nodes */

} /* end of nodal_data function */
