c**************************************************************
c     subroutine solver2d()
c     Purpose
c     =======
c     Subroutine to solve the linear system: Au = b for the 
c     Natural Element Method (NEM)
c
c**************************************************************
c
      subroutine solver2d()
      implicit none
c
c     include files for the solution phase (NEM program)
c
#include "include/params2d.h"
#include "include/node.h"
#include "include/stiffness.h"
#include "include/fext.h"
#include "include/solution.h"
c
      integer lda, ldb, info
      integer i
c
c     solution of the linear system Au = b using LAPACK routines
c     DPOTRF() and DPOTRS()
c
      lda = NSD*MAXNODES
      call dpotrf('u',NSD*no_of_nodes,A,lda,info)
      if (info .ne. 0) then
         write(6,*)'Error in dpotrf(): Flag is',info
         stop
      endif
c 
      ldb = NSD*no_of_nodes
      call dpotrs('u',NSD*no_of_nodes,1,A,lda,b,ldb,info)
      if (info .ne. 0) then
         write(6,*)'Error in dpotrs(): Flag is',info
         stop
      endif
c
c     system of linear equations Au = b successfully solved
c
      do 10 i = 1,NSD*no_of_nodes
         u(i) = b(i)
10    continue
c
      return
      end
