function relent1d(nbNodes,alphaGaussian,nbPoints)

% usage: relent1d(nbNodes,alphaGaussian,nbPoints)
% nbNodes        = number of nodes
% alphaGaussian  = constant in the Gaussian (inversely proportional to variance)
% nbPoints       = number of output points used for plotting
% Default values : nbNodes = 3; alphaGaussian = 0; nbPoints = 100
%                  alphaGaussian = 0 => Uniform Prior Distribution
% N. Sukumar     : UC DAVIS, August 2005

global alpha;

clc;
close all;

if nargin < 3, help(mfilename), nbNodes = 3; alphaGaussian = 0.; 
                                nbPoints = 100; end 

if nbNodes < 2, nbNodes = 2; end   
if alphaGaussian < 0, alphaGaussian = 0.; end
if nbPoints < 2, nbPoints = 10; end 

xI = linspace(0,1,nbNodes);

points = linspace(0,1,nbPoints);
alpha = alphaGaussian;

phi = computephi(points,xI);

w = computeweight(points,xI);

subplot(2,1,1);
plot(points,phi,'linewidth',2);

xlabel('x','FontSize',22);
ylabel('\phi','FontSize',22);
set(gca,'FontSize',18);

setlegend(nbNodes);

subplot(2,1,2);
plot(points,w,'linewidth',2);
xlabel('x','FontSize',22);
ylabel('w','FontSize',22);
set(gca,'FontSize',18);

return
