function  w = weight(dx,h,gamma)
%
% set dmax to be gamma times the nodal spacing
%

dmax = gamma*h;
r = abs(dx./dmax);

%
% Quartic weight function
%

w = 1. - 6.*r.*r + 8.*r.*r.*r - 3.*r.*r.*r.*r;

n = length(dx);
for i = 1:n
  if (w(i) < 0.)
    w(i) = 0.0;
  end
end
