function phi = phimlsstd(points,xI,gamma)

n = length(xI);
m = length(points);
phi = [];

p = [1 0];

%
% assuming uniform nodal spacing
%

h = xI(2) - xI(1);

for i = 1:m

  px = points(i);

  dx = xI - px.*ones(1,n);
  P = [ones(1,n); dx];

% compute mls shape functions: see, for example, "J. E. Dolbow and
% T. Belytschko, Archives for Computational Methods in Engineering,
% Vol. 5, Number 3, 207-241, 1998."
  
  dx = xI - px.*ones(1,n);
  diag = weight(dx,h,gamma);
  W = eye(n,n);
  for i = 1:n
    W(i,i) = diag(i);
  end
  A = P*W*P';
  B = P*W;
  phinew = B'*inv(A)*p';
  phinew = phinew';
  phi = [phi; phinew];
end
