function mls1d(nbNodes,gamma,nbPoints)

% usage: mls1d(nbNodes, gamma, nbPoints)
% nbNodes        = number of nodes
% gamma          = scaling factor for dmax [support size]
% nbPoints       = number of output points used for plotting
% Default values : nbNodes = 3; gamma = 1.1; nbPoints = 100
% N. Sukumar     : UC DAVIS, August 2005

clc;
close all;

if nargin < 3, help(mfilename), nbNodes = 3; gamma = 1.1; 
                                nbPoints = 100; end 

if nbNodes < 2, nbNodes = 2; end   
if gamma < 1.1, gamma = 1.1; end
if nbPoints < 2, nbPoints = 10; end 

xI = linspace(0,1,nbNodes);

points = linspace(0,1,nbPoints);

phi = phimlsstd(points,xI,gamma);

w   = computeweight(points,xI,gamma);

subplot(2,1,1);
plot(points,phi,'linewidth',2);

xlabel('x','FontSize',22);
ylabel('\phi','FontSize',22);
set(gca,'FontSize',18);

setlegend(nbNodes);

subplot(2,1,2);
plot(points,w,'linewidth',2);
set(gca,'FontSize',18);
xlabel('x','FontSize',22);
ylabel('w','FontSize',22);

return
