c**************************************************************
c     subroutine tecplot_nodes(n,coord)
c     Purpose
c     =======
c     Subroutine to output nodes in Tecplot format
c**************************************************************
c
      subroutine tecplot_nodes(n,coord)
      implicit none
c
      integer n
      real*8 coord(2,*)
c
c     integer counters
c
      integer i
c
      open(10,file='nodes.dat')
      do i = 1, n
         write(10,99)coord(1,i), coord(2,i)
         write(10,*)0.03
      enddo
c
99    format('GEOMETRY X = ',F10.5,'Y = ',F10.5, 'T=CIRCLE, C=BLACK,' 
     *       ,'FC = BLACK, CS = GRID')
c
      close(10)
      return
      end
c
c**************************************************************
c     subroutine tecplot_point(point)
c     Purpose
c     =======
c     Subroutine to output a point in Tecplot format
c**************************************************************
c
      subroutine tecplot_point(point)
      implicit none
c
      real*8 point(*)
c
      open(10,file='point.dat')
      write(10,99)point(1), point(2)
      write(10,*)0.02
c
99    format('GEOMETRY X = ',F10.5,'Y = ',F10.5, 'T=CIRCLE, C=RED,' 
     *       ,'FC = RED, CS = GRID')
c
      close(10)
      return
      end
c
c**************************************************************
c     subroutine tecplot_polygon(n,coord,thickness,filename)
c     Purpose
c     =======
c     Subroutine to output the polygon in Tecplot format
c**************************************************************
c
      subroutine tecplot_polygon(n,coord,thickness,filename)
      implicit none
c
      integer n
      real*8 coord(2,*)
      character*7 name
      character*11 filename
c
c     integer counters
c
      integer i
      integer n1, n2
      real*8 thickness
c     
      open(10,file = filename)
      do 10 i = 1,n
         if (i .eq. n) then
            n1 = i
            n2 = 1
         else
            n1 = i
            n2 = i+1
         endif

         write(10,99)thickness,1,2,coord(1,n1),coord(2,n1),
     *               coord(1,n2),coord(2,n2)
10    continue
c
99    format('GEOMETRY T=LINE, C=BLACK, L=SOLID, LT=',F10.5,' CS=GRID'
     *        ,/,I1,/,I1,/,F15.8,1x,F15.8,/,F15.8,1x,F15.8) 
c
      close(10)
      return
      end

c**************************************************************
c     subroutine tecplot_pointnode(n,point,coord)
c     Purpose
c     =======
c     Subroutine to output the segments in Tecplot format
c**************************************************************
c
      subroutine tecplot_pointnode(n,point,coord)
      implicit none
c
      integer n
      real*8 point(2), coord(2,*)
c
c     integer counters
c
      integer i
      real*8 line_thickness
      data line_thickness /0.2/
c     
      open(10,file = "pointtonode.dat")
      do 10 i = 1,n
         write(10,99)line_thickness,1,2,point(1),point(2),
     *               coord(1,i),coord(2,i)
10    continue
c
99    format('GEOMETRY T=LINE, C=BLUE, L=SOLID, LT=',F10.5,' CS=GRID'
     *        ,/,I1,/,I1,/,F15.8,1x,F15.8,/,F15.8,1x,F15.8) 
c
      close(10)
      return
      end
