      subroutine stress2d(epsx,sig)
c
c     generate 2-D Cauchy stresses
c
c     epsx(k,j)	: the (k-1)th derivative of the strain component j 
c     sig(k,j)	: the (k-1)th derivative of the stress component j 
c
c     sig(1,1) = sigma1	   sig(1,2) = sigma2    sig(1,3) =  sigma12
c
      implicit real*8 (a-h,o-z)
c
#include "include/material.h"
#include "include/gausspt_x.h"
c
      dimension sig(1,3), epsx(1,3)
c              
c     initialize the array to zero
c
      do 10 i = 1,3
	 sig(1,i) = 0.0d0
10    continue
c
c     2-D Cauchy stresses
c
      sig(1,1) = d1*epsx(1,1) + d2*epsx(1,2)
      sig(1,2) = d2*epsx(1,1) + d1*epsx(1,2)
      sig(1,3) = d3*epsx(1,3)
c
      return
      end
