      subroutine strain2d(n,ndi,phi,ui,epsx)
c
c     generate 2D small strains
c
c     phi(k,I)	: shape function and its kth derivative at node I
c     ui(I)	: nodal variables at data point I
c     epsx(k,j)	: the (k-1)th derivative of the strain component j 
c
c     epsx(1,1) = u_1,1  epsx(1,2) = u_2,2  epsx(1,3) = (u_1,2 + u_2,1)
c
      implicit real*8(a-h,o-z)
c
      dimension epsx(1,3), phi(3,*), ndi(*), ui(*)
c              
c     displacement gradients 
c
      u1x = 0.d0
      u1y = 0.d0
      u2x = 0.d0
      u2y = 0.d0
c
      do 10 J = 1,n
         k1 = 2*ndi(j) - 1
         k2 = 2*ndi(j)
         u1x = u1x + phi(2,j)*ui(k1)
         u1y = u1y + phi(3,j)*ui(k1)
         u2x = u2x + phi(2,j)*ui(k2)
         u2y = u2y + phi(3,j)*ui(k2)
10    continue
c
c     2D small strains
c
      epsx(1,1) = u1x
      epsx(1,2) = u2y
c
c     engineering shear strain
c
      epsx(1,3) = u1y + u2x
c
      return
      end
