/******************************************************
*
*  Function for reading constant input data (material
*  properties and problem type [plane stress/strain])
*  for the Natural Element Method (NEM)
*
******************************************************/

#include <stdio.h>
#include <string.h>

void constant_data(FILE *file_ptr,double constants[])

{
   int i, ns;
   char keyword[10], equal_to[1], line[200];
   double value;

   i = 0;
   while (1) {
      if (fgets(line,200,file_ptr) == NULL)  {
         printf("Error while reading line in Constants block data\n");
         exit(1);
      }
      ns = sscanf(line,"%s %s %lf",keyword,equal_to,&value);
      if (ns == 1) {
	 if (line[0] == '!') 
	    continue; /* comment line, so skip to next line */
         else
	    break; /* end of data for constants */
      }
      else if (ns == 3) {
         if (!strcmp(keyword,"E")) 
	    constants[i] = value;
         else if (!strcmp(keyword,"nu")) 
	    constants[i] = value;
         else if (!strcmp(keyword,"Problem")) 
	    constants[i] = value; /* value = 0 (plane stress)
	                             value = 1 (plane strain) */
         else {
	    printf("No match for %s in line %d (Constants block data)\n",keyword,i+1);
            exit(1);
         }
	 i++;
      }
      else { 
         printf("Error in line %d in Constants block data\n",
                 i+1);
	 exit(1);
      }
         
   }

} /* end of constant_data routine */
