c*****************************************************************
c     subroutine check_parmac(n,m,nnbc)
c     Purpose
c     =======
c     Check if the parameter settings in the include file 
c     "params2d.h" and the macro defs are valid or not
c
c*****************************************************************
c
      subroutine check_parmac(n,m,nnbc)
      implicit none
c
#include "include/params2d.h"
      integer n, m, nnbc
c
      if ((MAXNODES .lt. n) .or. (MAXTRIANGLES .lt. m) .or.
     &    (MAXNBCCELLS .lt. nnbc) .or. (MAXCONST .lt. 3) .or.
     &    (NSD .ne. 2) .or. (NODES_PER_TRIANGLE .ne. 3) .or.
     &    (NODES_PER_NBCCELL .ne. 2)) then
	  write(6,*)'Invalid parameter setting in params2d.h: aborting'
          write(6,*)'MAXNODES is ',MAXNODES,' n is ',n
          write(6,*)'MAXTRIANGLES is ',MAXTRIANGLES,' m is ',m
          write(6,*)'MAXNBCCELLS is ',MAXNBCCELLS,' nbc is ',nnbc
          write(6,*)'MAXCONST is ',MAXCONST
          write(6,*)'NODES_PER_TRIANGLE is ',NODES_PER_TRIANGLE
          write(6,*)'NODES_PER_NBCCELL is ',NODES_PER_NBCCELL
	  stop
      endif
c     
#if defined(PATCH_EBC) || defined(PLATE_HOLE)
#else
      write(6,*)'Macro PATCH_EBC or PLATE_HOLE undefined: aborting'
      stop
#endif
c
#ifdef FE
      write(6,*)'Elastostatic BVP using the Finite Element Method'
      write(6,*)'================================================'
      write(6,*)
#else
      write(6,*)'Elastostatic BVP using the Natural Element Method'
      write(6,*)'================================================='
      write(6,*)
#endif
c
      return
      end
