c*******************************************************************
c     subroutine material_constants(constants)
c     Purpose
c     =======
c     Set the material constants in the D-matrix for plane stress
c     or plane strain problems
c
c*******************************************************************
c
      subroutine material_constants(constants)
      implicit none
#include "include/material.h"
      real*8 constants(*)
      real*8 ym, ymt, ymbar, poisson, nubar, kappa
      common /equiv_material/ ymbar, nubar, kappa
c
c     d1, d2, d3 -> non-zero components in the D-matrix
c
      ym = constants(1)
      poisson = constants(2)
c
      if (int(constants(3)) .eq. 0) then ! plane stress
         ymbar = ym
         nubar = poisson
         kappa = (3.d0 - poisson)/(1.d0 + poisson)
         ymt = ym/(1.d0 - poisson**2)
         d1 = ymt
         d2 = ymt*poisson
         d3 = ymt*(1.0 - poisson)/2.0
         write(6,*)'Plane stress problem'
      elseif (int(constants(3)) .eq. 1) then ! plane strain 
         ymbar = ym/(1.d0 - poisson**2)
         nubar = poisson/(1.d0 - poisson)
         kappa = 3.d0 - 4.d0*poisson
         ymt = ym/((1.0 + poisson)*(1.0 - 2.0*poisson))
         d1 = ymt*(1.0 - poisson)
         d2 = ymt*poisson
         d3 = ymt*(1.0 - 2.0*poisson)/2.0
         write(6,*)'Plane strain problem'
      else
         write(6,*)'Problem type (plane stress/strain) not defined'
         stop
      endif
c
      write(6,*)
      write(6,*)'Material constants E and nu are:',ym,poisson
      write(6,*)
      write(6,*)'Material constants in the D-matrix'
      write(6,*)'==================================='
      write(6,*)'d1 =',d1
      write(6,*)'d2 =',d2
      write(6,*)'d3 =',d3
      write(6,*)
c
      return
      end
