function maxent1d(nbNodes,nbPoints)

% usage: maxent1d(nbNodes, nbPoints)
% nbNodes        = number of nodes
% nbPoints       = number of output points used for plotting
% Default values = nbNodes = 3; nbPoints = 100
% N. Sukumar     : UC DAVIS; June 2004

clc;
close all;

if nargin < 2, help(mfilename), nbNodes = 3; nbPoints = 100; end % default

if nbNodes < 2, nbNodes = 2; end   
if nbPoints < 2, nbPoints = 10; end 

xI = linspace(0,1,nbNodes);

points = linspace(0,1,nbPoints);

phi = computephi(points,xI);

plot(points,phi,'linewidth',2);

xlabel('x','FontSize',24);
ylabel('\phi','FontSize',24);
set(gca,'FontSize',22);

setlegend(nbNodes);

return
